﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


/* Standard query operators  
   Query syntax vs Method syntax */
namespace Lessons
{   
    public partial class MainForm : Form
    {
 
        public MainForm()
        {
            InitializeComponent();
        }


        /* Query syntax: using contextual keywords */
        private void button1_Click(object sender, EventArgs e)
        {
            int[] numbers = { 8, 5, 2, 9, 3, 0, 7, 1, 6, 4 };

            var q = from n in numbers
                    where n < 5
                    orderby n
                    select n;

            string S = "";

            foreach (int num in q)
                S += num.ToString() + Environment.NewLine;

            MessageBox.Show(S);
        }

        /* Method syntax: using standard query operators (method calls) */
        private void button2_Click(object sender, EventArgs e)
        {
            int[] numbers = { 8, 5, 2, 9, 3, 0, 7, 1, 6, 4 };

            var q = numbers.Where(n => n < 5)
                           .OrderBy(n => n);

            string S = "";

            foreach (int num in q)
                S += num.ToString() + Environment.NewLine;

            MessageBox.Show(S);
        }


        /* Method syntax: immediate execution ToList() */
        private void button3_Click(object sender, EventArgs e)
        {
            int[] numbers = { 8, 5, 2, 9, 3, 0, 7, 1, 6, 4 };

            var q = numbers.Where(n => n < 5)
                           .OrderBy(n => n)
                           .ToList();

            string S = "";

            foreach (int num in q)
                S += num.ToString() + Environment.NewLine;

            MessageBox.Show(S);
        }

        /* Method syntax: immediate execution ToArray() */
        private void button4_Click(object sender, EventArgs e)
        {
            int[] numbers = { 8, 5, 2, 9, 3, 0, 7, 1, 6, 4 };

            var q = numbers.Where(n => n < 5)
                           .OrderBy(n => n)
                           .ToArray();

            string S = "";

            foreach (int num in q)
                S += num.ToString() + Environment.NewLine;

            MessageBox.Show(S);
        }

        /* Method syntax: immediate execution ToArray() variation */
        private void button5_Click(object sender, EventArgs e)
        {
            int[] numbers = { 8, 5, 2, 9, 3, 0, 7, 1, 6, 4 };

            var q = numbers.Where(n => n < 5)
                           .OrderBy(n => n);

            var q2 = q.ToArray();

            string S = "";

            foreach (int num in q2)
                S += num.ToString() + Environment.NewLine;

            MessageBox.Show(S);
        }

        /* Query syntax: grouping */
        private void button6_Click(object sender, EventArgs e)
        {
            int[] numbers = { 8, 5, 2, 9, 3, 0, 7, 1, 6, 4 };

            var q = from n in numbers
                    orderby n
                    group n by n % 2 == 0 into g
                        orderby g.Key 
                        select g;

            string S = "";

            foreach (var g in q)
            {
                S += g.Key.ToString() + Environment.NewLine;

                foreach (int n in g)
                    S += "    " + n.ToString() + Environment.NewLine;
            }

            MessageBox.Show(S);
        }

        /* Method syntax: grouping */
        private void button7_Click(object sender, EventArgs e)
        {
            int[] numbers = new int[] { 8, 5, 2, 9, 3, 0, 7, 1, 6, 4 };

            var q = numbers.OrderBy(n => n)
                           .GroupBy(n => n % 2 == 0)
                           .OrderBy(g => g.Key);


            string S = "";

            foreach (var g in q)
            {
                S += g.Key.ToString() + Environment.NewLine;

                foreach (int n in g)
                    S += "    " + n.ToString() + Environment.NewLine;
            }

            MessageBox.Show(S);
 

        }
    }
}
